// Copyright 2014 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

// This file is autogenerated by:
//     mojo/public/tools/bindings/mojom_bindings_generator.py
// For:
//     mojo/services/network/public/interfaces/network_service.mojom
//

package org.chromium.mojom.mojo;

class NetworkService_Internal {

    public static final org.chromium.mojo.bindings.Interface.Manager<NetworkService, NetworkService.Proxy> MANAGER =
            new org.chromium.mojo.bindings.Interface.Manager<NetworkService, NetworkService.Proxy>() {
    
        public String getName() {
            return "mojo::NetworkService";
        }
    
        public int getVersion() {
          return 0;
        }
    
        public Proxy buildProxy(org.chromium.mojo.system.Core core,
                                org.chromium.mojo.bindings.MessageReceiverWithResponder messageReceiver) {
            return new Proxy(core, messageReceiver);
        }
    
        public Stub buildStub(org.chromium.mojo.system.Core core, NetworkService impl) {
            return new Stub(core, impl);
        }
    
        public NetworkService[] buildArray(int size) {
          return new NetworkService[size];
        }
    };

    private static final int CREATE_TCP_BOUND_SOCKET_ORDINAL = 0;
    private static final int CREATE_TCP_CONNECTED_SOCKET_ORDINAL = 1;
    private static final int CREATE_UDP_SOCKET_ORDINAL = 2;
    private static final int CREATE_HTTP_SERVER_ORDINAL = 3;
    private static final int GET_MIME_TYPE_FROM_FILE_ORDINAL = 4;

    static final class Proxy extends org.chromium.mojo.bindings.Interface.AbstractProxy implements NetworkService.Proxy {

        Proxy(org.chromium.mojo.system.Core core,
              org.chromium.mojo.bindings.MessageReceiverWithResponder messageReceiver) {
            super(core, messageReceiver);
        }

        @Override
        public void createTcpBoundSocket(NetAddress localAddress, org.chromium.mojo.bindings.InterfaceRequest<TcpBoundSocket> boundSocket, CreateTcpBoundSocketResponse callback) {
            NetworkServiceCreateTcpBoundSocketParams _message = new NetworkServiceCreateTcpBoundSocketParams();
            _message.localAddress = localAddress;
            _message.boundSocket = boundSocket;
            getProxyHandler().getMessageReceiver().acceptWithResponder(
                    _message.serializeWithHeader(
                            getProxyHandler().getCore(),
                            new org.chromium.mojo.bindings.MessageHeader(
                                    CREATE_TCP_BOUND_SOCKET_ORDINAL,
                                    org.chromium.mojo.bindings.MessageHeader.MESSAGE_EXPECTS_RESPONSE_FLAG,
                                    0)),
                    new NetworkServiceCreateTcpBoundSocketResponseParamsForwardToCallback(callback));
        }

        @Override
        public void createTcpConnectedSocket(NetAddress remoteAddress, org.chromium.mojo.system.DataPipe.ConsumerHandle sendStream, org.chromium.mojo.system.DataPipe.ProducerHandle receiveStream, org.chromium.mojo.bindings.InterfaceRequest<TcpConnectedSocket> clientSocket, CreateTcpConnectedSocketResponse callback) {
            NetworkServiceCreateTcpConnectedSocketParams _message = new NetworkServiceCreateTcpConnectedSocketParams();
            _message.remoteAddress = remoteAddress;
            _message.sendStream = sendStream;
            _message.receiveStream = receiveStream;
            _message.clientSocket = clientSocket;
            getProxyHandler().getMessageReceiver().acceptWithResponder(
                    _message.serializeWithHeader(
                            getProxyHandler().getCore(),
                            new org.chromium.mojo.bindings.MessageHeader(
                                    CREATE_TCP_CONNECTED_SOCKET_ORDINAL,
                                    org.chromium.mojo.bindings.MessageHeader.MESSAGE_EXPECTS_RESPONSE_FLAG,
                                    0)),
                    new NetworkServiceCreateTcpConnectedSocketResponseParamsForwardToCallback(callback));
        }

        @Override
        public void createUdpSocket(org.chromium.mojo.bindings.InterfaceRequest<UdpSocket> socket) {
            NetworkServiceCreateUdpSocketParams _message = new NetworkServiceCreateUdpSocketParams();
            _message.socket = socket;
            getProxyHandler().getMessageReceiver().accept(
                    _message.serializeWithHeader(
                            getProxyHandler().getCore(),
                            new org.chromium.mojo.bindings.MessageHeader(CREATE_UDP_SOCKET_ORDINAL)));
        }

        @Override
        public void createHttpServer(NetAddress localAddress, HttpServerDelegate delegate, CreateHttpServerResponse callback) {
            NetworkServiceCreateHttpServerParams _message = new NetworkServiceCreateHttpServerParams();
            _message.localAddress = localAddress;
            _message.delegate = delegate;
            getProxyHandler().getMessageReceiver().acceptWithResponder(
                    _message.serializeWithHeader(
                            getProxyHandler().getCore(),
                            new org.chromium.mojo.bindings.MessageHeader(
                                    CREATE_HTTP_SERVER_ORDINAL,
                                    org.chromium.mojo.bindings.MessageHeader.MESSAGE_EXPECTS_RESPONSE_FLAG,
                                    0)),
                    new NetworkServiceCreateHttpServerResponseParamsForwardToCallback(callback));
        }

        @Override
        public void getMimeTypeFromFile(String filePath, GetMimeTypeFromFileResponse callback) {
            NetworkServiceGetMimeTypeFromFileParams _message = new NetworkServiceGetMimeTypeFromFileParams();
            _message.filePath = filePath;
            getProxyHandler().getMessageReceiver().acceptWithResponder(
                    _message.serializeWithHeader(
                            getProxyHandler().getCore(),
                            new org.chromium.mojo.bindings.MessageHeader(
                                    GET_MIME_TYPE_FROM_FILE_ORDINAL,
                                    org.chromium.mojo.bindings.MessageHeader.MESSAGE_EXPECTS_RESPONSE_FLAG,
                                    0)),
                    new NetworkServiceGetMimeTypeFromFileResponseParamsForwardToCallback(callback));
        }

    }

    static final class Stub extends org.chromium.mojo.bindings.Interface.Stub<NetworkService> {

        Stub(org.chromium.mojo.system.Core core, NetworkService impl) {
            super(core, impl);
        }

        @Override
        public boolean accept(org.chromium.mojo.bindings.Message message) {
            try {
                org.chromium.mojo.bindings.ServiceMessage messageWithHeader =
                        message.asServiceMessage();
                org.chromium.mojo.bindings.MessageHeader header = messageWithHeader.getHeader();
                if (!header.validateHeader(org.chromium.mojo.bindings.MessageHeader.NO_FLAG)) {
                    return false;
                }
                switch(header.getType()) {
                    case org.chromium.mojo.bindings.InterfaceControlMessagesConstants.RUN_OR_CLOSE_PIPE_MESSAGE_ID:
                        return org.chromium.mojo.bindings.InterfaceControlMessagesHelper.handleRunOrClosePipe(
                                NetworkService_Internal.MANAGER, messageWithHeader);
                    case CREATE_UDP_SOCKET_ORDINAL: {
                        NetworkServiceCreateUdpSocketParams data =
                                NetworkServiceCreateUdpSocketParams.deserialize(messageWithHeader.getPayload());
                        getImpl().createUdpSocket(data.socket);
                        return true;
                    }
                    default:
                        return false;
                }
            } catch (org.chromium.mojo.bindings.DeserializationException e) {
                System.err.println(e.toString());
                return false;
            }
        }

        @Override
        public boolean acceptWithResponder(org.chromium.mojo.bindings.Message message, org.chromium.mojo.bindings.MessageReceiver receiver) {
            try {
                org.chromium.mojo.bindings.ServiceMessage messageWithHeader =
                        message.asServiceMessage();
                org.chromium.mojo.bindings.MessageHeader header = messageWithHeader.getHeader();
                if (!header.validateHeader(org.chromium.mojo.bindings.MessageHeader.MESSAGE_EXPECTS_RESPONSE_FLAG)) {
                    return false;
                }
                switch(header.getType()) {
                    case org.chromium.mojo.bindings.InterfaceControlMessagesConstants.RUN_MESSAGE_ID:
                        return org.chromium.mojo.bindings.InterfaceControlMessagesHelper.handleRun(
                                getCore(), NetworkService_Internal.MANAGER, messageWithHeader, receiver);
                    case CREATE_TCP_BOUND_SOCKET_ORDINAL: {
                        NetworkServiceCreateTcpBoundSocketParams data =
                                NetworkServiceCreateTcpBoundSocketParams.deserialize(messageWithHeader.getPayload());
                        getImpl().createTcpBoundSocket(data.localAddress, data.boundSocket, new NetworkServiceCreateTcpBoundSocketResponseParamsProxyToResponder(getCore(), receiver, header.getRequestId()));
                        return true;
                    }
                    case CREATE_TCP_CONNECTED_SOCKET_ORDINAL: {
                        NetworkServiceCreateTcpConnectedSocketParams data =
                                NetworkServiceCreateTcpConnectedSocketParams.deserialize(messageWithHeader.getPayload());
                        getImpl().createTcpConnectedSocket(data.remoteAddress, data.sendStream, data.receiveStream, data.clientSocket, new NetworkServiceCreateTcpConnectedSocketResponseParamsProxyToResponder(getCore(), receiver, header.getRequestId()));
                        return true;
                    }
                    case CREATE_HTTP_SERVER_ORDINAL: {
                        NetworkServiceCreateHttpServerParams data =
                                NetworkServiceCreateHttpServerParams.deserialize(messageWithHeader.getPayload());
                        getImpl().createHttpServer(data.localAddress, data.delegate, new NetworkServiceCreateHttpServerResponseParamsProxyToResponder(getCore(), receiver, header.getRequestId()));
                        return true;
                    }
                    case GET_MIME_TYPE_FROM_FILE_ORDINAL: {
                        NetworkServiceGetMimeTypeFromFileParams data =
                                NetworkServiceGetMimeTypeFromFileParams.deserialize(messageWithHeader.getPayload());
                        getImpl().getMimeTypeFromFile(data.filePath, new NetworkServiceGetMimeTypeFromFileResponseParamsProxyToResponder(getCore(), receiver, header.getRequestId()));
                        return true;
                    }
                    default:
                        return false;
                }
            } catch (org.chromium.mojo.bindings.DeserializationException e) {
                System.err.println(e.toString());
                return false;
            }
        }
    }

    static final class NetworkServiceCreateTcpBoundSocketParams extends org.chromium.mojo.bindings.Struct {
    
        private static final int STRUCT_SIZE = 24;
        private static final org.chromium.mojo.bindings.DataHeader[] VERSION_ARRAY = new org.chromium.mojo.bindings.DataHeader[] {new org.chromium.mojo.bindings.DataHeader(24, 0)};
        private static final org.chromium.mojo.bindings.DataHeader DEFAULT_STRUCT_INFO = VERSION_ARRAY[0];
    
        public NetAddress localAddress;
        public org.chromium.mojo.bindings.InterfaceRequest<TcpBoundSocket> boundSocket;
    
        private NetworkServiceCreateTcpBoundSocketParams(int version) {
            super(STRUCT_SIZE, version);
        }
    
        public NetworkServiceCreateTcpBoundSocketParams() {
            this(0);
        }
    
        public static NetworkServiceCreateTcpBoundSocketParams deserialize(org.chromium.mojo.bindings.Message message) {
            return decode(new org.chromium.mojo.bindings.Decoder(message));
        }
    
        @SuppressWarnings("unchecked")
        public static NetworkServiceCreateTcpBoundSocketParams decode(org.chromium.mojo.bindings.Decoder decoder0) {
            if (decoder0 == null) {
                return null;
            }
            org.chromium.mojo.bindings.DataHeader mainDataHeader = decoder0.readAndValidateDataHeader(VERSION_ARRAY);
            NetworkServiceCreateTcpBoundSocketParams result = new NetworkServiceCreateTcpBoundSocketParams(mainDataHeader.elementsOrVersion);
            if (mainDataHeader.elementsOrVersion >= 0) {
                org.chromium.mojo.bindings.Decoder decoder1 = decoder0.readPointer(8, true);
                result.localAddress = NetAddress.decode(decoder1);
            }
            if (mainDataHeader.elementsOrVersion >= 0) {
                result.boundSocket = decoder0.readInterfaceRequest(16, false);
            }
            return result;
        }
    
        @SuppressWarnings("unchecked")
        @Override
        protected final void encode(org.chromium.mojo.bindings.Encoder encoder) {
            org.chromium.mojo.bindings.Encoder encoder0 = encoder.getEncoderAtDataOffset(DEFAULT_STRUCT_INFO);
            encoder0.encode(localAddress, 8, true);
            encoder0.encode(boundSocket, 16, false);
        }
    
        /**
         * @see Object#equals(Object)
         */
        @Override
        public boolean equals(Object object) {
            if (object == this)
                return true;
            if (object == null)
                return false;
            if (getClass() != object.getClass())
                return false;
            NetworkServiceCreateTcpBoundSocketParams other = (NetworkServiceCreateTcpBoundSocketParams) object;
            if (!org.chromium.mojo.bindings.BindingsHelper.equals(this.localAddress, other.localAddress))
                return false;
            if (!org.chromium.mojo.bindings.BindingsHelper.equals(this.boundSocket, other.boundSocket))
                return false;
            return true;
        }
    
        /**
         * @see Object#hashCode()
         */
        @Override
        public int hashCode() {
            final int prime = 31;
            int result = prime + getClass().hashCode();
            result = prime * result + org.chromium.mojo.bindings.BindingsHelper.hashCode(localAddress);
            result = prime * result + org.chromium.mojo.bindings.BindingsHelper.hashCode(boundSocket);
            return result;
        }
    }

    static final class NetworkServiceCreateTcpBoundSocketResponseParams extends org.chromium.mojo.bindings.Struct {
    
        private static final int STRUCT_SIZE = 24;
        private static final org.chromium.mojo.bindings.DataHeader[] VERSION_ARRAY = new org.chromium.mojo.bindings.DataHeader[] {new org.chromium.mojo.bindings.DataHeader(24, 0)};
        private static final org.chromium.mojo.bindings.DataHeader DEFAULT_STRUCT_INFO = VERSION_ARRAY[0];
    
        public NetworkError result;
        public NetAddress boundTo;
    
        private NetworkServiceCreateTcpBoundSocketResponseParams(int version) {
            super(STRUCT_SIZE, version);
        }
    
        public NetworkServiceCreateTcpBoundSocketResponseParams() {
            this(0);
        }
    
        public static NetworkServiceCreateTcpBoundSocketResponseParams deserialize(org.chromium.mojo.bindings.Message message) {
            return decode(new org.chromium.mojo.bindings.Decoder(message));
        }
    
        @SuppressWarnings("unchecked")
        public static NetworkServiceCreateTcpBoundSocketResponseParams decode(org.chromium.mojo.bindings.Decoder decoder0) {
            if (decoder0 == null) {
                return null;
            }
            org.chromium.mojo.bindings.DataHeader mainDataHeader = decoder0.readAndValidateDataHeader(VERSION_ARRAY);
            NetworkServiceCreateTcpBoundSocketResponseParams result = new NetworkServiceCreateTcpBoundSocketResponseParams(mainDataHeader.elementsOrVersion);
            if (mainDataHeader.elementsOrVersion >= 0) {
                org.chromium.mojo.bindings.Decoder decoder1 = decoder0.readPointer(8, false);
                result.result = NetworkError.decode(decoder1);
            }
            if (mainDataHeader.elementsOrVersion >= 0) {
                org.chromium.mojo.bindings.Decoder decoder1 = decoder0.readPointer(16, true);
                result.boundTo = NetAddress.decode(decoder1);
            }
            return result;
        }
    
        @SuppressWarnings("unchecked")
        @Override
        protected final void encode(org.chromium.mojo.bindings.Encoder encoder) {
            org.chromium.mojo.bindings.Encoder encoder0 = encoder.getEncoderAtDataOffset(DEFAULT_STRUCT_INFO);
            encoder0.encode(result, 8, false);
            encoder0.encode(boundTo, 16, true);
        }
    
        /**
         * @see Object#equals(Object)
         */
        @Override
        public boolean equals(Object object) {
            if (object == this)
                return true;
            if (object == null)
                return false;
            if (getClass() != object.getClass())
                return false;
            NetworkServiceCreateTcpBoundSocketResponseParams other = (NetworkServiceCreateTcpBoundSocketResponseParams) object;
            if (!org.chromium.mojo.bindings.BindingsHelper.equals(this.result, other.result))
                return false;
            if (!org.chromium.mojo.bindings.BindingsHelper.equals(this.boundTo, other.boundTo))
                return false;
            return true;
        }
    
        /**
         * @see Object#hashCode()
         */
        @Override
        public int hashCode() {
            final int prime = 31;
            int result = prime + getClass().hashCode();
            result = prime * result + org.chromium.mojo.bindings.BindingsHelper.hashCode(result);
            result = prime * result + org.chromium.mojo.bindings.BindingsHelper.hashCode(boundTo);
            return result;
        }
    }

    static class NetworkServiceCreateTcpBoundSocketResponseParamsForwardToCallback extends org.chromium.mojo.bindings.SideEffectFreeCloseable
            implements org.chromium.mojo.bindings.MessageReceiver {
        private final NetworkService.CreateTcpBoundSocketResponse mCallback;

        NetworkServiceCreateTcpBoundSocketResponseParamsForwardToCallback(NetworkService.CreateTcpBoundSocketResponse callback) {
            this.mCallback = callback;
        }

        @Override
        public boolean accept(org.chromium.mojo.bindings.Message message) {
            try {
                org.chromium.mojo.bindings.ServiceMessage messageWithHeader =
                        message.asServiceMessage();
                org.chromium.mojo.bindings.MessageHeader header = messageWithHeader.getHeader();
                if (!header.validateHeader(CREATE_TCP_BOUND_SOCKET_ORDINAL,
                                           org.chromium.mojo.bindings.MessageHeader.MESSAGE_IS_RESPONSE_FLAG)) {
                    return false;
                }
                NetworkServiceCreateTcpBoundSocketResponseParams response = NetworkServiceCreateTcpBoundSocketResponseParams.deserialize(messageWithHeader.getPayload());
                mCallback.call(response.result, response.boundTo);
                return true;
            } catch (org.chromium.mojo.bindings.DeserializationException e) {
                return false;
            }
        }
    }

    static class NetworkServiceCreateTcpBoundSocketResponseParamsProxyToResponder implements NetworkService.CreateTcpBoundSocketResponse {

        private final org.chromium.mojo.system.Core mCore;
        private final org.chromium.mojo.bindings.MessageReceiver mMessageReceiver;
        private final long mRequestId;

        NetworkServiceCreateTcpBoundSocketResponseParamsProxyToResponder(
                org.chromium.mojo.system.Core core,
                org.chromium.mojo.bindings.MessageReceiver messageReceiver,
                long requestId) {
            mCore = core;
            mMessageReceiver = messageReceiver;
            mRequestId = requestId;
        }

        @Override
        public void call(NetworkError result, NetAddress boundTo) {
            NetworkServiceCreateTcpBoundSocketResponseParams _response = new NetworkServiceCreateTcpBoundSocketResponseParams();
            _response.result = result;
            _response.boundTo = boundTo;
            org.chromium.mojo.bindings.ServiceMessage _message =
                    _response.serializeWithHeader(
                            mCore,
                            new org.chromium.mojo.bindings.MessageHeader(
                                    CREATE_TCP_BOUND_SOCKET_ORDINAL,
                                    org.chromium.mojo.bindings.MessageHeader.MESSAGE_IS_RESPONSE_FLAG,
                                    mRequestId));
            mMessageReceiver.accept(_message);
        }
    }

    static final class NetworkServiceCreateTcpConnectedSocketParams extends org.chromium.mojo.bindings.Struct {
    
        private static final int STRUCT_SIZE = 32;
        private static final org.chromium.mojo.bindings.DataHeader[] VERSION_ARRAY = new org.chromium.mojo.bindings.DataHeader[] {new org.chromium.mojo.bindings.DataHeader(32, 0)};
        private static final org.chromium.mojo.bindings.DataHeader DEFAULT_STRUCT_INFO = VERSION_ARRAY[0];
    
        public NetAddress remoteAddress;
        public org.chromium.mojo.system.DataPipe.ConsumerHandle sendStream;
        public org.chromium.mojo.system.DataPipe.ProducerHandle receiveStream;
        public org.chromium.mojo.bindings.InterfaceRequest<TcpConnectedSocket> clientSocket;
    
        private NetworkServiceCreateTcpConnectedSocketParams(int version) {
            super(STRUCT_SIZE, version);
            sendStream = org.chromium.mojo.system.InvalidHandle.INSTANCE;
            receiveStream = org.chromium.mojo.system.InvalidHandle.INSTANCE;
        }
    
        public NetworkServiceCreateTcpConnectedSocketParams() {
            this(0);
        }
    
        public static NetworkServiceCreateTcpConnectedSocketParams deserialize(org.chromium.mojo.bindings.Message message) {
            return decode(new org.chromium.mojo.bindings.Decoder(message));
        }
    
        @SuppressWarnings("unchecked")
        public static NetworkServiceCreateTcpConnectedSocketParams decode(org.chromium.mojo.bindings.Decoder decoder0) {
            if (decoder0 == null) {
                return null;
            }
            org.chromium.mojo.bindings.DataHeader mainDataHeader = decoder0.readAndValidateDataHeader(VERSION_ARRAY);
            NetworkServiceCreateTcpConnectedSocketParams result = new NetworkServiceCreateTcpConnectedSocketParams(mainDataHeader.elementsOrVersion);
            if (mainDataHeader.elementsOrVersion >= 0) {
                org.chromium.mojo.bindings.Decoder decoder1 = decoder0.readPointer(8, false);
                result.remoteAddress = NetAddress.decode(decoder1);
            }
            if (mainDataHeader.elementsOrVersion >= 0) {
                result.sendStream = decoder0.readConsumerHandle(16, false);
            }
            if (mainDataHeader.elementsOrVersion >= 0) {
                result.receiveStream = decoder0.readProducerHandle(20, false);
            }
            if (mainDataHeader.elementsOrVersion >= 0) {
                result.clientSocket = decoder0.readInterfaceRequest(24, false);
            }
            return result;
        }
    
        @SuppressWarnings("unchecked")
        @Override
        protected final void encode(org.chromium.mojo.bindings.Encoder encoder) {
            org.chromium.mojo.bindings.Encoder encoder0 = encoder.getEncoderAtDataOffset(DEFAULT_STRUCT_INFO);
            encoder0.encode(remoteAddress, 8, false);
            encoder0.encode(sendStream, 16, false);
            encoder0.encode(receiveStream, 20, false);
            encoder0.encode(clientSocket, 24, false);
        }
    
        /**
         * @see Object#equals(Object)
         */
        @Override
        public boolean equals(Object object) {
            if (object == this)
                return true;
            if (object == null)
                return false;
            if (getClass() != object.getClass())
                return false;
            NetworkServiceCreateTcpConnectedSocketParams other = (NetworkServiceCreateTcpConnectedSocketParams) object;
            if (!org.chromium.mojo.bindings.BindingsHelper.equals(this.remoteAddress, other.remoteAddress))
                return false;
            if (!org.chromium.mojo.bindings.BindingsHelper.equals(this.sendStream, other.sendStream))
                return false;
            if (!org.chromium.mojo.bindings.BindingsHelper.equals(this.receiveStream, other.receiveStream))
                return false;
            if (!org.chromium.mojo.bindings.BindingsHelper.equals(this.clientSocket, other.clientSocket))
                return false;
            return true;
        }
    
        /**
         * @see Object#hashCode()
         */
        @Override
        public int hashCode() {
            final int prime = 31;
            int result = prime + getClass().hashCode();
            result = prime * result + org.chromium.mojo.bindings.BindingsHelper.hashCode(remoteAddress);
            result = prime * result + org.chromium.mojo.bindings.BindingsHelper.hashCode(sendStream);
            result = prime * result + org.chromium.mojo.bindings.BindingsHelper.hashCode(receiveStream);
            result = prime * result + org.chromium.mojo.bindings.BindingsHelper.hashCode(clientSocket);
            return result;
        }
    }

    static final class NetworkServiceCreateTcpConnectedSocketResponseParams extends org.chromium.mojo.bindings.Struct {
    
        private static final int STRUCT_SIZE = 24;
        private static final org.chromium.mojo.bindings.DataHeader[] VERSION_ARRAY = new org.chromium.mojo.bindings.DataHeader[] {new org.chromium.mojo.bindings.DataHeader(24, 0)};
        private static final org.chromium.mojo.bindings.DataHeader DEFAULT_STRUCT_INFO = VERSION_ARRAY[0];
    
        public NetworkError result;
        public NetAddress localAddress;
    
        private NetworkServiceCreateTcpConnectedSocketResponseParams(int version) {
            super(STRUCT_SIZE, version);
        }
    
        public NetworkServiceCreateTcpConnectedSocketResponseParams() {
            this(0);
        }
    
        public static NetworkServiceCreateTcpConnectedSocketResponseParams deserialize(org.chromium.mojo.bindings.Message message) {
            return decode(new org.chromium.mojo.bindings.Decoder(message));
        }
    
        @SuppressWarnings("unchecked")
        public static NetworkServiceCreateTcpConnectedSocketResponseParams decode(org.chromium.mojo.bindings.Decoder decoder0) {
            if (decoder0 == null) {
                return null;
            }
            org.chromium.mojo.bindings.DataHeader mainDataHeader = decoder0.readAndValidateDataHeader(VERSION_ARRAY);
            NetworkServiceCreateTcpConnectedSocketResponseParams result = new NetworkServiceCreateTcpConnectedSocketResponseParams(mainDataHeader.elementsOrVersion);
            if (mainDataHeader.elementsOrVersion >= 0) {
                org.chromium.mojo.bindings.Decoder decoder1 = decoder0.readPointer(8, false);
                result.result = NetworkError.decode(decoder1);
            }
            if (mainDataHeader.elementsOrVersion >= 0) {
                org.chromium.mojo.bindings.Decoder decoder1 = decoder0.readPointer(16, true);
                result.localAddress = NetAddress.decode(decoder1);
            }
            return result;
        }
    
        @SuppressWarnings("unchecked")
        @Override
        protected final void encode(org.chromium.mojo.bindings.Encoder encoder) {
            org.chromium.mojo.bindings.Encoder encoder0 = encoder.getEncoderAtDataOffset(DEFAULT_STRUCT_INFO);
            encoder0.encode(result, 8, false);
            encoder0.encode(localAddress, 16, true);
        }
    
        /**
         * @see Object#equals(Object)
         */
        @Override
        public boolean equals(Object object) {
            if (object == this)
                return true;
            if (object == null)
                return false;
            if (getClass() != object.getClass())
                return false;
            NetworkServiceCreateTcpConnectedSocketResponseParams other = (NetworkServiceCreateTcpConnectedSocketResponseParams) object;
            if (!org.chromium.mojo.bindings.BindingsHelper.equals(this.result, other.result))
                return false;
            if (!org.chromium.mojo.bindings.BindingsHelper.equals(this.localAddress, other.localAddress))
                return false;
            return true;
        }
    
        /**
         * @see Object#hashCode()
         */
        @Override
        public int hashCode() {
            final int prime = 31;
            int result = prime + getClass().hashCode();
            result = prime * result + org.chromium.mojo.bindings.BindingsHelper.hashCode(result);
            result = prime * result + org.chromium.mojo.bindings.BindingsHelper.hashCode(localAddress);
            return result;
        }
    }

    static class NetworkServiceCreateTcpConnectedSocketResponseParamsForwardToCallback extends org.chromium.mojo.bindings.SideEffectFreeCloseable
            implements org.chromium.mojo.bindings.MessageReceiver {
        private final NetworkService.CreateTcpConnectedSocketResponse mCallback;

        NetworkServiceCreateTcpConnectedSocketResponseParamsForwardToCallback(NetworkService.CreateTcpConnectedSocketResponse callback) {
            this.mCallback = callback;
        }

        @Override
        public boolean accept(org.chromium.mojo.bindings.Message message) {
            try {
                org.chromium.mojo.bindings.ServiceMessage messageWithHeader =
                        message.asServiceMessage();
                org.chromium.mojo.bindings.MessageHeader header = messageWithHeader.getHeader();
                if (!header.validateHeader(CREATE_TCP_CONNECTED_SOCKET_ORDINAL,
                                           org.chromium.mojo.bindings.MessageHeader.MESSAGE_IS_RESPONSE_FLAG)) {
                    return false;
                }
                NetworkServiceCreateTcpConnectedSocketResponseParams response = NetworkServiceCreateTcpConnectedSocketResponseParams.deserialize(messageWithHeader.getPayload());
                mCallback.call(response.result, response.localAddress);
                return true;
            } catch (org.chromium.mojo.bindings.DeserializationException e) {
                return false;
            }
        }
    }

    static class NetworkServiceCreateTcpConnectedSocketResponseParamsProxyToResponder implements NetworkService.CreateTcpConnectedSocketResponse {

        private final org.chromium.mojo.system.Core mCore;
        private final org.chromium.mojo.bindings.MessageReceiver mMessageReceiver;
        private final long mRequestId;

        NetworkServiceCreateTcpConnectedSocketResponseParamsProxyToResponder(
                org.chromium.mojo.system.Core core,
                org.chromium.mojo.bindings.MessageReceiver messageReceiver,
                long requestId) {
            mCore = core;
            mMessageReceiver = messageReceiver;
            mRequestId = requestId;
        }

        @Override
        public void call(NetworkError result, NetAddress localAddress) {
            NetworkServiceCreateTcpConnectedSocketResponseParams _response = new NetworkServiceCreateTcpConnectedSocketResponseParams();
            _response.result = result;
            _response.localAddress = localAddress;
            org.chromium.mojo.bindings.ServiceMessage _message =
                    _response.serializeWithHeader(
                            mCore,
                            new org.chromium.mojo.bindings.MessageHeader(
                                    CREATE_TCP_CONNECTED_SOCKET_ORDINAL,
                                    org.chromium.mojo.bindings.MessageHeader.MESSAGE_IS_RESPONSE_FLAG,
                                    mRequestId));
            mMessageReceiver.accept(_message);
        }
    }

    static final class NetworkServiceCreateUdpSocketParams extends org.chromium.mojo.bindings.Struct {
    
        private static final int STRUCT_SIZE = 16;
        private static final org.chromium.mojo.bindings.DataHeader[] VERSION_ARRAY = new org.chromium.mojo.bindings.DataHeader[] {new org.chromium.mojo.bindings.DataHeader(16, 0)};
        private static final org.chromium.mojo.bindings.DataHeader DEFAULT_STRUCT_INFO = VERSION_ARRAY[0];
    
        public org.chromium.mojo.bindings.InterfaceRequest<UdpSocket> socket;
    
        private NetworkServiceCreateUdpSocketParams(int version) {
            super(STRUCT_SIZE, version);
        }
    
        public NetworkServiceCreateUdpSocketParams() {
            this(0);
        }
    
        public static NetworkServiceCreateUdpSocketParams deserialize(org.chromium.mojo.bindings.Message message) {
            return decode(new org.chromium.mojo.bindings.Decoder(message));
        }
    
        @SuppressWarnings("unchecked")
        public static NetworkServiceCreateUdpSocketParams decode(org.chromium.mojo.bindings.Decoder decoder0) {
            if (decoder0 == null) {
                return null;
            }
            org.chromium.mojo.bindings.DataHeader mainDataHeader = decoder0.readAndValidateDataHeader(VERSION_ARRAY);
            NetworkServiceCreateUdpSocketParams result = new NetworkServiceCreateUdpSocketParams(mainDataHeader.elementsOrVersion);
            if (mainDataHeader.elementsOrVersion >= 0) {
                result.socket = decoder0.readInterfaceRequest(8, false);
            }
            return result;
        }
    
        @SuppressWarnings("unchecked")
        @Override
        protected final void encode(org.chromium.mojo.bindings.Encoder encoder) {
            org.chromium.mojo.bindings.Encoder encoder0 = encoder.getEncoderAtDataOffset(DEFAULT_STRUCT_INFO);
            encoder0.encode(socket, 8, false);
        }
    
        /**
         * @see Object#equals(Object)
         */
        @Override
        public boolean equals(Object object) {
            if (object == this)
                return true;
            if (object == null)
                return false;
            if (getClass() != object.getClass())
                return false;
            NetworkServiceCreateUdpSocketParams other = (NetworkServiceCreateUdpSocketParams) object;
            if (!org.chromium.mojo.bindings.BindingsHelper.equals(this.socket, other.socket))
                return false;
            return true;
        }
    
        /**
         * @see Object#hashCode()
         */
        @Override
        public int hashCode() {
            final int prime = 31;
            int result = prime + getClass().hashCode();
            result = prime * result + org.chromium.mojo.bindings.BindingsHelper.hashCode(socket);
            return result;
        }
    }

    static final class NetworkServiceCreateHttpServerParams extends org.chromium.mojo.bindings.Struct {
    
        private static final int STRUCT_SIZE = 24;
        private static final org.chromium.mojo.bindings.DataHeader[] VERSION_ARRAY = new org.chromium.mojo.bindings.DataHeader[] {new org.chromium.mojo.bindings.DataHeader(24, 0)};
        private static final org.chromium.mojo.bindings.DataHeader DEFAULT_STRUCT_INFO = VERSION_ARRAY[0];
    
        public NetAddress localAddress;
        public HttpServerDelegate delegate;
    
        private NetworkServiceCreateHttpServerParams(int version) {
            super(STRUCT_SIZE, version);
        }
    
        public NetworkServiceCreateHttpServerParams() {
            this(0);
        }
    
        public static NetworkServiceCreateHttpServerParams deserialize(org.chromium.mojo.bindings.Message message) {
            return decode(new org.chromium.mojo.bindings.Decoder(message));
        }
    
        @SuppressWarnings("unchecked")
        public static NetworkServiceCreateHttpServerParams decode(org.chromium.mojo.bindings.Decoder decoder0) {
            if (decoder0 == null) {
                return null;
            }
            org.chromium.mojo.bindings.DataHeader mainDataHeader = decoder0.readAndValidateDataHeader(VERSION_ARRAY);
            NetworkServiceCreateHttpServerParams result = new NetworkServiceCreateHttpServerParams(mainDataHeader.elementsOrVersion);
            if (mainDataHeader.elementsOrVersion >= 0) {
                org.chromium.mojo.bindings.Decoder decoder1 = decoder0.readPointer(8, false);
                result.localAddress = NetAddress.decode(decoder1);
            }
            if (mainDataHeader.elementsOrVersion >= 0) {
                result.delegate = decoder0.readServiceInterface(16, false, HttpServerDelegate.MANAGER);
            }
            return result;
        }
    
        @SuppressWarnings("unchecked")
        @Override
        protected final void encode(org.chromium.mojo.bindings.Encoder encoder) {
            org.chromium.mojo.bindings.Encoder encoder0 = encoder.getEncoderAtDataOffset(DEFAULT_STRUCT_INFO);
            encoder0.encode(localAddress, 8, false);
            encoder0.encode(delegate, 16, false, HttpServerDelegate.MANAGER);
        }
    
        /**
         * @see Object#equals(Object)
         */
        @Override
        public boolean equals(Object object) {
            if (object == this)
                return true;
            if (object == null)
                return false;
            if (getClass() != object.getClass())
                return false;
            NetworkServiceCreateHttpServerParams other = (NetworkServiceCreateHttpServerParams) object;
            if (!org.chromium.mojo.bindings.BindingsHelper.equals(this.localAddress, other.localAddress))
                return false;
            if (!org.chromium.mojo.bindings.BindingsHelper.equals(this.delegate, other.delegate))
                return false;
            return true;
        }
    
        /**
         * @see Object#hashCode()
         */
        @Override
        public int hashCode() {
            final int prime = 31;
            int result = prime + getClass().hashCode();
            result = prime * result + org.chromium.mojo.bindings.BindingsHelper.hashCode(localAddress);
            result = prime * result + org.chromium.mojo.bindings.BindingsHelper.hashCode(delegate);
            return result;
        }
    }

    static final class NetworkServiceCreateHttpServerResponseParams extends org.chromium.mojo.bindings.Struct {
    
        private static final int STRUCT_SIZE = 24;
        private static final org.chromium.mojo.bindings.DataHeader[] VERSION_ARRAY = new org.chromium.mojo.bindings.DataHeader[] {new org.chromium.mojo.bindings.DataHeader(24, 0)};
        private static final org.chromium.mojo.bindings.DataHeader DEFAULT_STRUCT_INFO = VERSION_ARRAY[0];
    
        public NetworkError result;
        public NetAddress boundTo;
    
        private NetworkServiceCreateHttpServerResponseParams(int version) {
            super(STRUCT_SIZE, version);
        }
    
        public NetworkServiceCreateHttpServerResponseParams() {
            this(0);
        }
    
        public static NetworkServiceCreateHttpServerResponseParams deserialize(org.chromium.mojo.bindings.Message message) {
            return decode(new org.chromium.mojo.bindings.Decoder(message));
        }
    
        @SuppressWarnings("unchecked")
        public static NetworkServiceCreateHttpServerResponseParams decode(org.chromium.mojo.bindings.Decoder decoder0) {
            if (decoder0 == null) {
                return null;
            }
            org.chromium.mojo.bindings.DataHeader mainDataHeader = decoder0.readAndValidateDataHeader(VERSION_ARRAY);
            NetworkServiceCreateHttpServerResponseParams result = new NetworkServiceCreateHttpServerResponseParams(mainDataHeader.elementsOrVersion);
            if (mainDataHeader.elementsOrVersion >= 0) {
                org.chromium.mojo.bindings.Decoder decoder1 = decoder0.readPointer(8, false);
                result.result = NetworkError.decode(decoder1);
            }
            if (mainDataHeader.elementsOrVersion >= 0) {
                org.chromium.mojo.bindings.Decoder decoder1 = decoder0.readPointer(16, true);
                result.boundTo = NetAddress.decode(decoder1);
            }
            return result;
        }
    
        @SuppressWarnings("unchecked")
        @Override
        protected final void encode(org.chromium.mojo.bindings.Encoder encoder) {
            org.chromium.mojo.bindings.Encoder encoder0 = encoder.getEncoderAtDataOffset(DEFAULT_STRUCT_INFO);
            encoder0.encode(result, 8, false);
            encoder0.encode(boundTo, 16, true);
        }
    
        /**
         * @see Object#equals(Object)
         */
        @Override
        public boolean equals(Object object) {
            if (object == this)
                return true;
            if (object == null)
                return false;
            if (getClass() != object.getClass())
                return false;
            NetworkServiceCreateHttpServerResponseParams other = (NetworkServiceCreateHttpServerResponseParams) object;
            if (!org.chromium.mojo.bindings.BindingsHelper.equals(this.result, other.result))
                return false;
            if (!org.chromium.mojo.bindings.BindingsHelper.equals(this.boundTo, other.boundTo))
                return false;
            return true;
        }
    
        /**
         * @see Object#hashCode()
         */
        @Override
        public int hashCode() {
            final int prime = 31;
            int result = prime + getClass().hashCode();
            result = prime * result + org.chromium.mojo.bindings.BindingsHelper.hashCode(result);
            result = prime * result + org.chromium.mojo.bindings.BindingsHelper.hashCode(boundTo);
            return result;
        }
    }

    static class NetworkServiceCreateHttpServerResponseParamsForwardToCallback extends org.chromium.mojo.bindings.SideEffectFreeCloseable
            implements org.chromium.mojo.bindings.MessageReceiver {
        private final NetworkService.CreateHttpServerResponse mCallback;

        NetworkServiceCreateHttpServerResponseParamsForwardToCallback(NetworkService.CreateHttpServerResponse callback) {
            this.mCallback = callback;
        }

        @Override
        public boolean accept(org.chromium.mojo.bindings.Message message) {
            try {
                org.chromium.mojo.bindings.ServiceMessage messageWithHeader =
                        message.asServiceMessage();
                org.chromium.mojo.bindings.MessageHeader header = messageWithHeader.getHeader();
                if (!header.validateHeader(CREATE_HTTP_SERVER_ORDINAL,
                                           org.chromium.mojo.bindings.MessageHeader.MESSAGE_IS_RESPONSE_FLAG)) {
                    return false;
                }
                NetworkServiceCreateHttpServerResponseParams response = NetworkServiceCreateHttpServerResponseParams.deserialize(messageWithHeader.getPayload());
                mCallback.call(response.result, response.boundTo);
                return true;
            } catch (org.chromium.mojo.bindings.DeserializationException e) {
                return false;
            }
        }
    }

    static class NetworkServiceCreateHttpServerResponseParamsProxyToResponder implements NetworkService.CreateHttpServerResponse {

        private final org.chromium.mojo.system.Core mCore;
        private final org.chromium.mojo.bindings.MessageReceiver mMessageReceiver;
        private final long mRequestId;

        NetworkServiceCreateHttpServerResponseParamsProxyToResponder(
                org.chromium.mojo.system.Core core,
                org.chromium.mojo.bindings.MessageReceiver messageReceiver,
                long requestId) {
            mCore = core;
            mMessageReceiver = messageReceiver;
            mRequestId = requestId;
        }

        @Override
        public void call(NetworkError result, NetAddress boundTo) {
            NetworkServiceCreateHttpServerResponseParams _response = new NetworkServiceCreateHttpServerResponseParams();
            _response.result = result;
            _response.boundTo = boundTo;
            org.chromium.mojo.bindings.ServiceMessage _message =
                    _response.serializeWithHeader(
                            mCore,
                            new org.chromium.mojo.bindings.MessageHeader(
                                    CREATE_HTTP_SERVER_ORDINAL,
                                    org.chromium.mojo.bindings.MessageHeader.MESSAGE_IS_RESPONSE_FLAG,
                                    mRequestId));
            mMessageReceiver.accept(_message);
        }
    }

    static final class NetworkServiceGetMimeTypeFromFileParams extends org.chromium.mojo.bindings.Struct {
    
        private static final int STRUCT_SIZE = 16;
        private static final org.chromium.mojo.bindings.DataHeader[] VERSION_ARRAY = new org.chromium.mojo.bindings.DataHeader[] {new org.chromium.mojo.bindings.DataHeader(16, 0)};
        private static final org.chromium.mojo.bindings.DataHeader DEFAULT_STRUCT_INFO = VERSION_ARRAY[0];
    
        public String filePath;
    
        private NetworkServiceGetMimeTypeFromFileParams(int version) {
            super(STRUCT_SIZE, version);
        }
    
        public NetworkServiceGetMimeTypeFromFileParams() {
            this(0);
        }
    
        public static NetworkServiceGetMimeTypeFromFileParams deserialize(org.chromium.mojo.bindings.Message message) {
            return decode(new org.chromium.mojo.bindings.Decoder(message));
        }
    
        @SuppressWarnings("unchecked")
        public static NetworkServiceGetMimeTypeFromFileParams decode(org.chromium.mojo.bindings.Decoder decoder0) {
            if (decoder0 == null) {
                return null;
            }
            org.chromium.mojo.bindings.DataHeader mainDataHeader = decoder0.readAndValidateDataHeader(VERSION_ARRAY);
            NetworkServiceGetMimeTypeFromFileParams result = new NetworkServiceGetMimeTypeFromFileParams(mainDataHeader.elementsOrVersion);
            if (mainDataHeader.elementsOrVersion >= 0) {
                result.filePath = decoder0.readString(8, false);
            }
            return result;
        }
    
        @SuppressWarnings("unchecked")
        @Override
        protected final void encode(org.chromium.mojo.bindings.Encoder encoder) {
            org.chromium.mojo.bindings.Encoder encoder0 = encoder.getEncoderAtDataOffset(DEFAULT_STRUCT_INFO);
            encoder0.encode(filePath, 8, false);
        }
    
        /**
         * @see Object#equals(Object)
         */
        @Override
        public boolean equals(Object object) {
            if (object == this)
                return true;
            if (object == null)
                return false;
            if (getClass() != object.getClass())
                return false;
            NetworkServiceGetMimeTypeFromFileParams other = (NetworkServiceGetMimeTypeFromFileParams) object;
            if (!org.chromium.mojo.bindings.BindingsHelper.equals(this.filePath, other.filePath))
                return false;
            return true;
        }
    
        /**
         * @see Object#hashCode()
         */
        @Override
        public int hashCode() {
            final int prime = 31;
            int result = prime + getClass().hashCode();
            result = prime * result + org.chromium.mojo.bindings.BindingsHelper.hashCode(filePath);
            return result;
        }
    }

    static final class NetworkServiceGetMimeTypeFromFileResponseParams extends org.chromium.mojo.bindings.Struct {
    
        private static final int STRUCT_SIZE = 16;
        private static final org.chromium.mojo.bindings.DataHeader[] VERSION_ARRAY = new org.chromium.mojo.bindings.DataHeader[] {new org.chromium.mojo.bindings.DataHeader(16, 0)};
        private static final org.chromium.mojo.bindings.DataHeader DEFAULT_STRUCT_INFO = VERSION_ARRAY[0];
    
        public String mimeType;
    
        private NetworkServiceGetMimeTypeFromFileResponseParams(int version) {
            super(STRUCT_SIZE, version);
        }
    
        public NetworkServiceGetMimeTypeFromFileResponseParams() {
            this(0);
        }
    
        public static NetworkServiceGetMimeTypeFromFileResponseParams deserialize(org.chromium.mojo.bindings.Message message) {
            return decode(new org.chromium.mojo.bindings.Decoder(message));
        }
    
        @SuppressWarnings("unchecked")
        public static NetworkServiceGetMimeTypeFromFileResponseParams decode(org.chromium.mojo.bindings.Decoder decoder0) {
            if (decoder0 == null) {
                return null;
            }
            org.chromium.mojo.bindings.DataHeader mainDataHeader = decoder0.readAndValidateDataHeader(VERSION_ARRAY);
            NetworkServiceGetMimeTypeFromFileResponseParams result = new NetworkServiceGetMimeTypeFromFileResponseParams(mainDataHeader.elementsOrVersion);
            if (mainDataHeader.elementsOrVersion >= 0) {
                result.mimeType = decoder0.readString(8, false);
            }
            return result;
        }
    
        @SuppressWarnings("unchecked")
        @Override
        protected final void encode(org.chromium.mojo.bindings.Encoder encoder) {
            org.chromium.mojo.bindings.Encoder encoder0 = encoder.getEncoderAtDataOffset(DEFAULT_STRUCT_INFO);
            encoder0.encode(mimeType, 8, false);
        }
    
        /**
         * @see Object#equals(Object)
         */
        @Override
        public boolean equals(Object object) {
            if (object == this)
                return true;
            if (object == null)
                return false;
            if (getClass() != object.getClass())
                return false;
            NetworkServiceGetMimeTypeFromFileResponseParams other = (NetworkServiceGetMimeTypeFromFileResponseParams) object;
            if (!org.chromium.mojo.bindings.BindingsHelper.equals(this.mimeType, other.mimeType))
                return false;
            return true;
        }
    
        /**
         * @see Object#hashCode()
         */
        @Override
        public int hashCode() {
            final int prime = 31;
            int result = prime + getClass().hashCode();
            result = prime * result + org.chromium.mojo.bindings.BindingsHelper.hashCode(mimeType);
            return result;
        }
    }

    static class NetworkServiceGetMimeTypeFromFileResponseParamsForwardToCallback extends org.chromium.mojo.bindings.SideEffectFreeCloseable
            implements org.chromium.mojo.bindings.MessageReceiver {
        private final NetworkService.GetMimeTypeFromFileResponse mCallback;

        NetworkServiceGetMimeTypeFromFileResponseParamsForwardToCallback(NetworkService.GetMimeTypeFromFileResponse callback) {
            this.mCallback = callback;
        }

        @Override
        public boolean accept(org.chromium.mojo.bindings.Message message) {
            try {
                org.chromium.mojo.bindings.ServiceMessage messageWithHeader =
                        message.asServiceMessage();
                org.chromium.mojo.bindings.MessageHeader header = messageWithHeader.getHeader();
                if (!header.validateHeader(GET_MIME_TYPE_FROM_FILE_ORDINAL,
                                           org.chromium.mojo.bindings.MessageHeader.MESSAGE_IS_RESPONSE_FLAG)) {
                    return false;
                }
                NetworkServiceGetMimeTypeFromFileResponseParams response = NetworkServiceGetMimeTypeFromFileResponseParams.deserialize(messageWithHeader.getPayload());
                mCallback.call(response.mimeType);
                return true;
            } catch (org.chromium.mojo.bindings.DeserializationException e) {
                return false;
            }
        }
    }

    static class NetworkServiceGetMimeTypeFromFileResponseParamsProxyToResponder implements NetworkService.GetMimeTypeFromFileResponse {

        private final org.chromium.mojo.system.Core mCore;
        private final org.chromium.mojo.bindings.MessageReceiver mMessageReceiver;
        private final long mRequestId;

        NetworkServiceGetMimeTypeFromFileResponseParamsProxyToResponder(
                org.chromium.mojo.system.Core core,
                org.chromium.mojo.bindings.MessageReceiver messageReceiver,
                long requestId) {
            mCore = core;
            mMessageReceiver = messageReceiver;
            mRequestId = requestId;
        }

        @Override
        public void call(String mimeType) {
            NetworkServiceGetMimeTypeFromFileResponseParams _response = new NetworkServiceGetMimeTypeFromFileResponseParams();
            _response.mimeType = mimeType;
            org.chromium.mojo.bindings.ServiceMessage _message =
                    _response.serializeWithHeader(
                            mCore,
                            new org.chromium.mojo.bindings.MessageHeader(
                                    GET_MIME_TYPE_FROM_FILE_ORDINAL,
                                    org.chromium.mojo.bindings.MessageHeader.MESSAGE_IS_RESPONSE_FLAG,
                                    mRequestId));
            mMessageReceiver.accept(_message);
        }
    }

}

